﻿#include "precompiled.h"
#include "common.h"
#include "VertexShader.h"

using namespace DirectX;

namespace RTCam {

VertexShader::VertexShader(void) :
	m_vertexShader(nullptr)
{
}


VertexShader::~VertexShader(void)
{
}

ComPtr<ID3DBlob> VertexShader::Load(_In_z_ const char* filename, _In_ ID3D11Device1* d3dDevice )
{
	ComPtr<ID3DBlob> shaderBlob = LoadShader(filename, "main", "vs_5_0");

	ThrowIfFailed(
		d3dDevice->CreateVertexShader(
		shaderBlob->GetBufferPointer(),
		shaderBlob->GetBufferSize(),
		nullptr,
		&m_vertexShader
		)
		);

	SetDebugObjectName(m_vertexShader.Get(), filename);

	return shaderBlob;
}

} // end namespace